

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdlib.h>
#include "ioconsole.h"
#include "ls020_init.h"
#include "ls020_draw.h"
#include "ls020_chr_v.h"
#include "spritefon.h"
#include "spriteshow.h"
#include "spritehide.h"


unsigned char tek[40];
unsigned char old[40];
unsigned char kp;		//   
unsigned char firepos;  //  
unsigned char chelpos;  //  
unsigned int firepause; //    
unsigned int movepause; //    
unsigned char tekmove; //   
unsigned int total;// 
unsigned int bad; //  
#define cFirePause 5000 //    
#define cMovePause 2500 //    
//  
void console_init()
{
 cli();  				// all interrupts disabled
 port_init();
 ls020_init_lcd(); 		// Init LS020 LCD
 ls020_8bit_mode(0); 	// Set 8bit LCD host mode
 ls020_fillscreen(0xFF);
}

//   
void ShowGameScreen()
{
ls020_prm_sprite(fon0);
ls020_prm_sprite(fon1);
ls020_prm_sprite(fon2);
ls020_prm_sprite(fon3);
ls020_prm_sprite(show62);
}

void ShowStartScreen()
{
ShowGameScreen();
char txt[]=" ";
char txt0[]="  ";
char txt1[]="  ";
ls020_put_string8(176/2-ls020_width_string(txt)/2,50,txt,0,255);
ls020_put_string8(176/2-ls020_width_string(txt0)/2,59,txt0,0,255);
ls020_put_string8(176/2-ls020_width_string(txt1)/2,66,txt1,0,255);
wait_key_pressed();
wait_key_unpressed()
ls020_fillscreen(255);
ShowGameScreen();
}


void ShowEndScreen()
{
ShowGameScreen();
char txt[]=" ";
char txt1[]="  ";
ls020_put_string8(176/2-ls020_width_string(txt)/2,50,txt,0,255);
ls020_put_string8(176/2-ls020_width_string(txt1)/2,59,txt1,0,255);
wait_key_pressed();
wait_key_unpressed()
ls020_fillscreen(255);
ShowGameScreen();
}


//  
void RefreshScreen()
{
if ((tek[0]==1) & (old[0]==0)) ls020_prm_sprite(show0);

if ((tek[1]==1) & (old[1]==0)) ls020_prm_sprite(show1);

if ((tek[2]==1) & (old[2]==0)) ls020_prm_sprite(show2);

if ((tek[3]==1) & (old[3]==0)) ls020_prm_sprite(show3);

if ((tek[4]==1) & (old[4]==0)) ls020_prm_sprite(show4);

if ((tek[5]==1) & (old[5]==0)) ls020_prm_sprite(show5);

if ((tek[6]==1) & (old[6]==0)) ls020_prm_sprite(show6);

if ((tek[7]==1) & (old[7]==0)) ls020_prm_sprite(show7);

if ((tek[8]==1) & (old[8]==0)) ls020_prm_sprite(show8);

if ((tek[9]==1) & (old[9]==0)) ls020_prm_sprite(show9);

if ((tek[10]==1) & (old[10]==0)) ls020_prm_sprite(show10);

if ((tek[11]==1) & (old[11]==0)) ls020_prm_sprite(show11);

if ((tek[12]==1) & (old[12]==0)) ls020_prm_sprite(show12);

if ((tek[13]==1) & (old[13]==0)) ls020_prm_sprite(show13);

if ((tek[14]==1) & (old[14]==0)) ls020_prm_sprite(show14);

if ((tek[15]==1) & (old[15]==0)) ls020_prm_sprite(show15);

if ((tek[16]==1) & (old[16]==0)) ls020_prm_sprite(show16);

if ((tek[17]==1) & (old[17]==0)) ls020_prm_sprite(show17);

if ((tek[18]==1) & (old[18]==0)) ls020_prm_sprite(show18);

if ((tek[19]==1) & (old[19]==0)) ls020_prm_sprite(show19);

if ((tek[20]==1) & (old[20]==0)) ls020_prm_sprite(show20);

if ((tek[21]==1) & (old[21]==0)) ls020_prm_sprite(show21);

if ((tek[22]==1) & (old[22]==0)) ls020_prm_sprite(show22);

// 
if ((tek[23]==1) & (old[23]==0)) {
ls020_prm_sprite(show23);
ls020_prm_sprite(show24);
}
// 
if ((tek[24]==1) & (old[24]==0)) {
ls020_prm_sprite(show25);
ls020_prm_sprite(show26);
ls020_prm_sprite(show27);
}
// 
if ((tek[25]==1) & (old[25]==0)) {
ls020_prm_sprite(show28);
ls020_prm_sprite(show29);
}
// 
if ((tek[26]==1) & (old[26]==0)) {
ls020_prm_sprite(show30);
ls020_prm_sprite(show31);
ls020_prm_sprite(show32);
ls020_prm_sprite(show33);
}
// 
if ((tek[27]==1) & (old[27]==0)) {
ls020_prm_sprite(show34);
ls020_prm_sprite(show35);
ls020_prm_sprite(show36);
ls020_prm_sprite(show37);
}
// 
if ((tek[28]==1) & (old[28]==0)) {
ls020_prm_sprite(show38);
ls020_prm_sprite(show39);
ls020_prm_sprite(show40);
ls020_prm_sprite(show41);
}

// 
if ((tek[29]==1) & (old[29]==0)) {
ls020_prm_sprite(show42);
ls020_prm_sprite(show43);
ls020_prm_sprite(show44);
}

// 
if ((tek[30]==1) & (old[30]==0)) {
ls020_prm_sprite(show45);
ls020_prm_sprite(show46);
ls020_prm_sprite(show47);
ls020_prm_sprite(show48);
ls020_prm_sprite(show49);
}
// 
if ((tek[31]==1) & (old[31]==0)) {
ls020_prm_sprite(show50);
ls020_prm_sprite(show51);
ls020_prm_sprite(show52);
ls020_prm_sprite(show53);
}
// 
if ((tek[32]==1) & (old[32]==0)) {
ls020_prm_sprite(show54);
ls020_prm_sprite(show55);
ls020_prm_sprite(show56);
}
//
if ((tek[33]==1) & (old[33]==0))ls020_prm_sprite(show57);

if ((tek[34]==1) & (old[34]==0))ls020_prm_sprite(show58);

if ((tek[35]==1) & (old[35]==0))ls020_prm_sprite(show59);
// 
if ((tek[36]==1) & (old[36]==0)) {
ls020_prm_sprite(show60);
ls020_prm_sprite(show61);
}

if ((tek[0]==0) & (old[0]==1)) ls020_prm_sprite(hide0);

if ((tek[1]==0) & (old[1]==1)) ls020_prm_sprite(hide1);

if ((tek[2]==0) & (old[2]==1)) ls020_prm_sprite(hide2);

if ((tek[3]==0) & (old[3]==1)) ls020_prm_sprite(hide3);

if ((tek[4]==0) & (old[4]==1)) ls020_prm_sprite(hide4);

if ((tek[5]==0) & (old[5]==1)) ls020_prm_sprite(hide5);

if ((tek[6]==0) & (old[6]==1)) ls020_prm_sprite(hide6);

if ((tek[7]==0) & (old[7]==1)) ls020_prm_sprite(hide7);

if ((tek[8]==0) & (old[8]==1)) ls020_prm_sprite(hide8);

if ((tek[9]==0) & (old[9]==1)) ls020_prm_sprite(hide9);

if ((tek[10]==0) & (old[10]==1)) ls020_prm_sprite(hide10);

if ((tek[11]==0) & (old[11]==1)) ls020_prm_sprite(hide11);

if ((tek[12]==0) & (old[12]==1)) ls020_prm_sprite(hide12);

if ((tek[13]==0) & (old[13]==1)) ls020_prm_sprite(hide13);

if ((tek[14]==0) & (old[14]==1)) ls020_prm_sprite(hide14);

if ((tek[15]==0) & (old[15]==1)) ls020_prm_sprite(hide15);

if ((tek[16]==0) & (old[16]==1)) ls020_prm_sprite(hide16);

if ((tek[17]==0) & (old[17]==1)) ls020_prm_sprite(hide17);

if ((tek[18]==0) & (old[18]==1)) ls020_prm_sprite(hide18);

if ((tek[19]==0) & (old[19]==1)) ls020_prm_sprite(hide19);

if ((tek[20]==0) & (old[20]==1)) ls020_prm_sprite(hide20);

if ((tek[21]==0) & (old[21]==1)) ls020_prm_sprite(hide21);

if ((tek[22]==0) & (old[22]==1)) ls020_prm_sprite(hide22);

if ((tek[23]==0) & (old[23]==1)) {
ls020_prm_sprite(hide23);
ls020_prm_sprite(hide24);
}

if ((tek[24]==0) & (old[24]==1)) {
ls020_prm_sprite(hide25);
ls020_prm_sprite(hide26);
ls020_prm_sprite(hide27);
}

if ((tek[25]==0) & (old[25]==1)) {
ls020_prm_sprite(hide28);
ls020_prm_sprite(hide29);
}

if ((tek[26]==0) & (old[26]==1)) {
ls020_prm_sprite(hide30);
ls020_prm_sprite(hide31);
ls020_prm_sprite(hide32);
ls020_prm_sprite(hide33);
}

if ((tek[27]==0) & (old[27]==1)) {
ls020_prm_sprite(hide34);
ls020_prm_sprite(hide35);
ls020_prm_sprite(hide36);
ls020_prm_sprite(hide37);
}

if ((tek[28]==0) & (old[28]==1)) {
ls020_prm_sprite(hide38);
ls020_prm_sprite(hide39);
ls020_prm_sprite(hide40);
ls020_prm_sprite(hide41);
}


if ((tek[29]==0) & (old[29]==1)) {
ls020_prm_sprite(hide42);
ls020_prm_sprite(hide43);
ls020_prm_sprite(hide44);
}


if ((tek[30]==0) & (old[30]==1)) {
ls020_prm_sprite(hide45);
ls020_prm_sprite(hide46);
ls020_prm_sprite(hide47);
ls020_prm_sprite(hide48);
ls020_prm_sprite(hide49);
}

if ((tek[31]==0) & (old[31]==1)) {
ls020_prm_sprite(hide50);
ls020_prm_sprite(hide51);
ls020_prm_sprite(hide52);
ls020_prm_sprite(hide53);
}

if ((tek[32]==0) & (old[32]==1)) {
ls020_prm_sprite(hide54);
ls020_prm_sprite(hide55);
ls020_prm_sprite(hide56);
}
//
if ((tek[33]==0) & (old[33]==1))ls020_prm_sprite(hide57);

if ((tek[34]==0) & (old[34]==1))ls020_prm_sprite(hide58);

if ((tek[35]==0) & (old[35]==1))ls020_prm_sprite(hide59);
//
if ((tek[36]==0) & (old[36]==1)) {
ls020_prm_sprite(hide60);
ls020_prm_sprite(hide61);
}

//   
unsigned char u;
for (u=0;u<37;u++) {old[u]=tek[u];}

}

//    
void InitStartGame()
{
unsigned char u;
for (u=0;u<37;u++) {tek[u]=0;old[u]=0;}
firepos=29;
firepause=0;
movepause=0;
chelpos=26;
tekmove=21;
total=0;
bad=0;
kp=0;
}

//  
void ShowFire()
{
firepause++;
tek[firepos]=1;
if (firepause==cFirePause)  
		{
		tek[firepos]=0;
		firepos++;
		if (firepos==33) firepos=29;
		tek[firepos]=1;
		firepause=0;
		}
}

// 
void ShowChel()
{
tek[26]=0;tek[27]=0;tek[28]=0;
tek[chelpos]=1;
}

unsigned char MoveChel()
{
unsigned char p;
p=PINC;
if (p==255) kp=0;
if (((p & VK_KEY6)==0)&&(chelpos!=28)&&(kp==0)) {chelpos++;kp=1;} 
if (((p & VK_KEY4)==0)&&(chelpos!=26)&&(kp==0)) {chelpos--;kp=1;} 
return p;
}


unsigned char FindLastCH(unsigned char i)
{
unsigned char u;
u=i;
while (u!=0)
	{
		if (tek[u]==1) return u;
		u--;
	}
	if (tek[0]==0) u=255;
	return u;
}



void draw_score(unsigned char score, unsigned char lines)
{
  char text[] = "000 ";
  for(unsigned char i=2; i>0; i--)
  {
    text[i] = 0x30 + score % 10;
    score/=10;
  }
  ls020_put_string8(145,15,text,0x00,0xFF);

  for(unsigned char i=2; i>0; i--)
  {
    text[i] = 0x30 + lines % 10;
    lines/=10;
  }
  ls020_put_string8(145,28,text,0x00,0xFF);
}


void FlashUpal(unsigned char i)
{
unsigned char p;
unsigned char o;
tek[i]=0;
if (i==4) o=23;
if (i==12) o=24;
if (i==18) o=25;
for (p=1;p<4;p++) 
{
	tek[o]=1;
	RefreshScreen();
	_delay_ms(300);
	tek[o]=0;
	RefreshScreen();
	_delay_ms(300);
}




}

void MoveVertva()
{
movepause++;
if (movepause==cMovePause) 
	{
	movepause=0;
	tekmove=FindLastCH(tekmove);

	if ((tekmove==4)&&(chelpos!=26)) {FlashUpal(tekmove);bad++;draw_score(total,bad);return;}
	if ((tekmove==12)&&(chelpos!=27)) {FlashUpal(tekmove);bad++;draw_score(total,bad);return;}
	if ((tekmove==18)&&(chelpos!=28)) {FlashUpal(tekmove);bad++;draw_score(total,bad);return;}


	if (tekmove==255) 
		{
			tekmove=21;
			if ((rand() % 10)>=8) tek[0]=1; 	
		} 
		else
		{
			tek[tekmove]=0;
			if (tekmove!=21) tek[tekmove+1]=1;
			if (tekmove==21) {total++;draw_score(total,bad);}
		}

	}

}


void PlayGame()
{
draw_score(total,bad);
unsigned char k;
tek[0]=1;
while (1)
{
	k=MoveChel();
	if ((k & VK_KEY1)==0) {wait_key_unpressed();break;}
	if ((k & VK_KEY2)==0) {ls020_off_lcd();while (1){}}
	ShowFire();
	ShowChel();
	MoveVertva();
	RefreshScreen();
	if (bad==20) break;
}
}



void main (void)
{
  _delay_ms(100);
   console_init();
  while (1) 
  {
  ShowStartScreen();
  InitStartGame();
  PlayGame();
  ShowEndScreen();
  }
}
